﻿//////////////////////////////////////////////
// OutputFormatter.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestClassObserverInformation ;
	class TestFunctionObserverInformation ;
	class TestRunParameters ;
}

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

// nkLog
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT OutputFormatter
	{
		public :

			// Constructor, destructor
			OutputFormatter () noexcept ;
			virtual ~OutputFormatter () ;

			// Formatting
			virtual nkMemory::String formatRunLaunch (const TestRunParameters& params) ;
			virtual nkMemory::String formatRunEnd () ;
			virtual nkMemory::String formatClassLaunch (const TestClassObserverInformation& info) ;
			virtual nkMemory::String formatClassBypass (const TestClassObserverInformation& info) ;
			virtual nkMemory::String formatClassEnd (const TestClassObserverInformation& info) ;
			virtual nkMemory::String formatTestLaunch (const TestFunctionObserverInformation& info) ;
			virtual nkMemory::String formatTestBypass (const TestFunctionObserverInformation& info) ;
			virtual nkMemory::String formatTestSuccess (const TestFunctionObserverInformation& info) ;
			virtual nkMemory::String formatTestFailure (const TestFunctionObserverInformation& info) ;
	} ;
}